Public Class COven
  '========== Constants =================
  Private Const DOOROPEN = True       ' Oven door open
  Private Const DOORCLOSED = 0        ' Oven door closed
  Private Const OVENON = True         ' Oven on
  Private Const OVENOFF = 0           ' Oven off
  Private Const LIGHTON = True        ' Oven light on
  Private Const LIGHTOFF = 0          ' Oven light off
  Private Const BROILTEMP = 550       ' Broiler temperature
  Private Const CLEANTEMP = 600       ' Self-clean temperature

  '========== class member data ==========
  Private mOvenStatus As Integer      ' Is the oven on or off
  Private mTemperature As Integer     ' Oven temperature
  Private mDoorStatus As Integer      ' Is oven door open or closed
  Private mOvenLight As Integer       ' Is oven light on or off


  '========== Constructor ================
  Public Sub New()
    ' Purpose: To initialize the variables to their proper values.
    '           Even though some are zero, we set them explicitly.
    mOvenStatus = OVENOFF       ' Oven is off
    mTemperature = 0            ' No temperature
    mDoorStatus = DOORCLOSED    ' Oven door is closed
    mOvenLight = LIGHTOFF       ' Oven light is off

  End Sub

  '================ Properties ===========
  Public Property OvenStatus() As Integer
    ' Purpose:  To get the current status of the oven.
    '           0 = oven off, 1 = oven on
    Get
      Return mOvenStatus
    End Get

    ' Purpose:  To change the status of the oven. It 
    '           is assumed that Value is the desired
    '           temperature. Value = 0 means the oven 
    '           is off. Any other value indicates a
    '           desired temperature value.
    Set(ByVal Value As Integer) ' Turn oven on or off
      Dim Flag As Integer

      If Value <> OVENOFF Then
        mOvenStatus = 1       ' Oven is now on
      Else
        mOvenStatus = 0       ' Oven is now off
      End If
      Flag = Bake(Value)

    End Set
  End Property

  Public Property DoorStatus() As Integer
    ' Purpose:  This property opens or closes the oven door

    Get
      Return mDoorStatus
    End Get

    Set(ByVal Value As Integer)
      If Value = 0 Then
        mDoorStatus = DOORCLOSED
      Else
        mDoorStatus = DOOROPEN
      End If
    End Set
  End Property

  Public Property LightStatus() As Integer
    Get
      Return mOvenLight
    End Get

    Set(ByVal Value As Integer)
      If Value = 0 Then
        mOvenLight = LIGHTOFF
      Else
        mOvenLight = LIGHTON
      End If

    End Set
  End Property


  Public Property Temperature() As Integer

    Get
      Return mTemperature
    End Get

    Set(ByVal Value As Integer)
      Dim Flag As Integer

      If Value < 0 Then
        mTemperature = 0
      End If
      Flag = Bake(Value)      ' Set the oven temperature
    End Set
  End Property

  '================ Methods ==============

  Public Function Bake(ByVal Temp As Integer) As Integer
    ' Purpose:  This method is used to set the oven temperature
    '           to the temperature passed to this method.
    '
    ' Argument list:
    '   temp      the desired temperature 
    '
    ' Return value:
    '   integer   1 if everything is OK, 0 on error
    '
    If mOvenStatus = OVENOFF Then   ' Oven is now off
      Return 0                      ' Error
    End If

    mTemperature = Temp       ' Since oven is on, set temperature
    Return 1                  ' Everything's OK

  End Function

  Public Function Preheat(ByVal Temp As Integer) As Integer
    ' Purpose:  This method is used to preheat the oven 
    '           temperature to the value passed to this method.
    '
    ' Argument list:
    '   temp      the desired temperature 
    '
    ' Return value:
    '   integer   1 if everything is OK, 0 on error
    '
    Return Bake(Temp)

  End Function

  Public Sub Broil()
    ' Purpose:  This method is used to turn on the broiler 
    '           in the oven .
    '
    ' Argument list:
    '   N/A
    '
    ' Return value:
    '   N/A   
    '
    mTemperature = BROILTEMP

  End Sub

  Public Sub SelfClean()
    ' Purpose:  This method is used to self-clean the oven. 
    '
    ' Argument list:
    '   N/A
    '
    ' Return value:
    '   N/A   
    '
    mTemperature = CLEANTEMP

  End Sub

End Class
